<?php
session_start();
require_once '../config/db.php'; 

if ($_SESSION['role'] !== 'waiter' && $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['action'] === 'add_new_item') {
    $order_id = (int)$_GET['order_id'];
    $item_id = (int)$_POST['add_item_id'];
    $quantity = (int)$_POST['quantity'];
    
    if ($quantity < 1) $quantity = 1;
    
    $message = '';
    $error = '';

    // 1. Sifariş statusunu yoxla (yalnız new və active dəyişilə bilər)
    $stmt = $conn->prepare("SELECT status FROM orders WHERE id = ?");
    $stmt->bind_param("i", $order_id);
    $stmt->execute();
    $order_status = $stmt->get_result()->fetch_assoc()['status'] ?? null;
    $stmt->close();

    if ($order_status !== 'new' && $order_status !== 'active') {
        $error = "Məhsul əlavə etmək mümkün deyil. Sifarişin statusu: " . strtoupper($order_status);
        header('Location: order_view.php?order_id=' . $order_id . '&error=' . urlencode($error));
        exit;
    }

    // 2. Məhsulun cari qiymətini tapırıq
    $stmt = $conn->prepare("SELECT name, sale_price FROM menu_items WHERE id = ?");
    $stmt->bind_param("i", $item_id);
    $stmt->execute();
    $item_data = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if ($item_data) {
        $price = $item_data['sale_price'];
        $item_name = $item_data['name'];
        
        // --- ƏSAS DƏYİŞİKLİK: HƏR ZAMAN YENİ ORDER_ITEM SƏTRİ ƏLAVƏ EDİLİR ---
        // Sifariş xətti hər dəfə yeni əlavə olunur ki, fərqli çatdırılma statusu olsun
        $stmt = $conn->prepare("
            INSERT INTO order_items (order_id, menu_item_id, quantity, delivery_status, item_add_date, price_at_order) 
            VALUES (?, ?, ?, 'pending', NOW(), ?)
        ");
        // Param tiplərinə diqqət edin: iiid (integer, integer, integer, double)
        $stmt->bind_param("iiid", $order_id, $item_id, $quantity, $price);
        
        if ($stmt->execute()) {
            $message = htmlspecialchars($item_name) . " (" . $quantity . " ədəd) sifarişə yeni sətir olaraq əlavə edildi.";
        } else {
            $error = "Məhsulu əlavə etmək mümkün olmadı: " . $stmt->error;
        }
        $stmt->close();


        // TOTAL AMOUNT yenilənməlidir
        $conn->query("UPDATE orders SET total_amount = (SELECT IFNULL(SUM(quantity * price_at_order), 0) FROM order_items WHERE order_id = $order_id) WHERE id = $order_id");
        
    } else {
        $error = "Məhsul tapılmadı.";
    }

    // Əsas səhifəyə geri yönləndir
    header('Location: order_view.php?order_id=' . $order_id . '&message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;

} else {
    header('Location: index.php?error=' . urlencode('Yanlış sorğu.'));
    exit;
}
?>