<?php
// Bütün PHP səhifələrində session'ı başlatmaq lazımdır.
session_start();
// Verilənlər bazası qoşulmasını daxil edirik.
require_once 'config/db.php';

// Əgər istifadəçi artıq daxil olubsa və aktivdirsə, onu dashboard-a yönləndiririk
if (isset($_SESSION['user_id'])) {
    if ($_SESSION['role'] == 'admin') {
        header('Location: admin/index.php');
    } else {
        header('Location: waiter/index.php');
    }
    exit;
}

// Giriş Cəhdi Məntiqi
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = $_POST['password'];

    // SQL Injection-dan qorunmaq üçün hazırlanmış ifadələrdən istifadə edirik
    $stmt = $conn->prepare("SELECT id, username, password, role, is_active FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        
        // Şifrənin yoxlanılması
        if ($password === $user['password']) {
            
            // AKTİVLİK YOXLANMASI
            if ((int)$user['is_active'] !== 1) {
                $error = "Sizin hesabınız deaktiv edilib. Zəhmət olmasa rəhbərliyə müraciət edin.";
            } else {
                // Giriş Uğurlu - Sessiyaları yaradırıq
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['role'] = $user['role'];

                // Roluna görə dashboard-a yönləndirmə
                if ($user['role'] == 'admin') {
                    header('Location: admin/index.php');
                } else {
                    header('Location: waiter/index.php');
                }
                exit;
            }
        } else {
            $error = "İstifadəçi adı və ya şifrə yanlışdır.";
        }
    } else {
        $error = "İstifadəçi adı və ya şifrə yanlışdır.";
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="az">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restoran POS | Giriş</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .login-container { min-height: 100vh; display: flex; align-items: center; justify-content: center; }
        .card { border: none; border-radius: 15px; }
    </style>
</head>
<body>

    <div class="container login-container">
        <div class="card shadow-lg p-4" style="max-width: 400px; width: 100%;">
            <div class="card-body">
                <h3 class="card-title text-center mb-4 fw-bold">MyPOS Giriş</h3>
                <p class="text-center text-muted small">Davam etmək üçün məlumatları daxil edin</p>
                
                <?php if ($error): ?>
                    <div class="alert alert-danger" role="alert" style="font-size: 0.9rem;">
                        <i class="fas fa-exclamation-triangle me-2"></i> <?= $error ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="index.php">
                    <div class="mb-3">
                        <label for="username" class="form-label">İstifadəçi Adı</label>
                        <input type="text" class="form-control" id="username" name="username" required autocomplete="username">
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Şifrə</label>
                        <input type="password" class="form-control" id="password" name="password" required autocomplete="current-password">
                    </div>
                    <div class="d-grid mt-4">
                        <button type="submit" class="btn btn-dark py-2 fw-bold">DAXİL OL</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/your-code.js" crossorigin="anonymous"></script>
</body>
</html>