<?php
session_start();
$page_title = "İstifadəçilərin İdarə Edilməsi";
require_once '../includes/header.php'; 

// Yalnız Adminlər bu səhifəyə daxil ola bilər
if ($_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';


// --- 1. Silmə Əməliyyatı (DELETE) ---
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $user_id = (int)$_GET['id'];
    
    // Admin özünü silməsinin qarşısını alırıq
    if ($user_id == $_SESSION['user_id']) {
        $error = "Öz hesabınızı silə bilməzsiniz.";
    } else {
        $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
        $stmt->bind_param("i", $user_id);
        
        if ($stmt->execute()) {
            $message = "İstifadəçi uğurla silindi.";
        } else {
            $error = "İstifadəçini silmək mümkün olmadı: Öncə onunla əlaqəli bütün sifarişləri silin." . $conn->error;
        }
        $stmt->close();
    }
    
    header('Location: users.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// --- 2. Aktiv/Deaktiv (Toggle Status) Əməliyyatı ---
if (isset($_GET['action']) && $_GET['action'] == 'toggle_status' && isset($_GET['id']) && isset($_GET['status'])) {
    $user_id = (int)$_GET['id'];
    $new_status = (int)$_GET['status'] == 1 ? 1 : 0; 

    // Admin öz aktiv statusunu özbaşına dəyişə bilməz
    if ($user_id == $_SESSION['user_id'] && $new_status === 0) {
        $error = "Öz aktiv statusunuzu bu yolla dəyişdirib sistemi tərk edə bilməzsiniz.";
    } else {
        $stmt = $conn->prepare("UPDATE users SET is_active = ? WHERE id = ?");
        $stmt->bind_param("ii", $new_status, $user_id);
        
        if ($stmt->execute()) {
            $message = "İstifadəçi statusu uğurla dəyişdirildi.";
        } else {
            $error = "Statusu dəyişdirmək mümkün olmadı: " . $conn->error;
        }
        $stmt->close();
    }
    
    header('Location: users.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}


// --- 3. Yaratma/Dəyişdirmə Əməliyyatı (CREATE / UPDATE) (DÜZƏLİŞ) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $role = $_POST['role'];
    $password = $_POST['password'];
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $salary = (float)$_POST['salary'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $edit_id = (isset($_POST['edit_id']) && $_POST['edit_id'] != '') ? (int)$_POST['edit_id'] : null;

    $is_valid = true;
    
    if (empty($username) || empty($first_name) || empty($last_name)) {
         $error = "Zəhmət olmasa bütün tələb olunan sahələri doldurun.";
         $is_valid = false;
    }
    
    if ($is_valid) {
        if ($edit_id) {
            // UPDATE əməliyyatı: Şifrə boş olub-olmamasından asılı olaraq iki fərqli sorğu
            if (empty($password)) {
                // Şifrə dəyişmir
                $sql = "UPDATE users SET username=?, first_name=?, last_name=?, role=?, salary=?, is_active=? WHERE id=?";
                $stmt = $conn->prepare($sql);
                // 4 's' (string), 1 'd' (double), 2 'i' (integer) -> 7 param
                $stmt->bind_param("ssssdii", $username, $first_name, $last_name, $role, $salary, $is_active, $edit_id);
            } else {
                // Şifrə dəyişir
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $sql = "UPDATE users SET username=?, first_name=?, last_name=?, role=?, salary=?, is_active=?, password=? WHERE id=?";
                $stmt = $conn->prepare($sql);
                // 5 's' (string, şifrə daxil), 1 'd' (double), 2 'i' (integer) -> 8 param
                $stmt->bind_param("ssssdisi", $username, $first_name, $last_name, $role, $salary, $is_active, $hashed_password, $edit_id);
            }
            $action_message = "İstifadəçi uğurla dəyişdirildi.";

        } else {
            // CREATE əməliyyatı: Şifrə tələb olunur
            if (empty($password)) {
                $error = "Yeni istifadəçi üçün şifrə tələb olunur.";
                $is_valid = false;
            } else {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $conn->prepare("INSERT INTO users (username, password, first_name, last_name, role, salary, is_active) VALUES (?, ?, ?, ?, ?, ?, ?)");
                // 5 's' (username, password, first, last, role), 1 'd' (salary), 1 'i' (is_active) -> 7 param
                $stmt->bind_param("sssssdi", $username, $hashed_password, $first_name, $last_name, $role, $salary, $is_active);
                $action_message = "Yeni istifadəçi uğurla əlavə edildi.";
            }
        }
    }


    if ($is_valid && isset($stmt) && $stmt->execute()) {
        $message = $action_message;
    } else if ($is_valid && isset($stmt)) {
        // Eyni username və ya digər DB səhvi
        $error = "Əməliyyat uğursuz oldu: İstifadəçi adı təkrarlana bilər və ya digər səhv var. (" . $conn->error . ")";
    } else if (!$is_valid) {
        // Xəta is_valid yoxlamasından gəlir (məsələn, şifrənin boş olması)
    }
    
    if (isset($stmt)) {
        $stmt->close();
    }
    
    header('Location: users.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// --- 4. Dəyişdirmə üçün Datayı Yükləmə (READ Single) ---
$user_to_edit = null;
if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
    $edit_id = (int)$_GET['id'];
    $stmt = $conn->prepare("SELECT id, username, first_name, last_name, role, salary, is_active FROM users WHERE id = ?");
    $stmt->bind_param("i", $edit_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows == 1) {
        $user_to_edit = $result->fetch_assoc();
    }
    $stmt->close();
}


// --- 5. Bütün İstifadəçilərin Siyahısı (READ All) ---
$users = [];
$sql = "SELECT id, username, first_name, last_name, role, salary, is_active, created_at FROM users ORDER BY id DESC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
}
?>

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><i class="fas fa-check-circle me-2"></i> <?= htmlspecialchars($message) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-4 mb-4">
        <div class="card shadow">
            <div class="card-header py-3" style="background-color: #20c997; color: white;">
                <h6 class="m-0 font-weight-bold"><?= $user_to_edit ? 'İstifadəçini Dəyişdir' : 'Yeni İstifadəçi Əlavə Et' ?></h6>
            </div>
            <div class="card-body">
                <form action="users.php" method="POST">
                    <input type="hidden" name="edit_id" value="<?= $user_to_edit ? $user_to_edit['id'] : '' ?>">
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="first_name" class="form-label">Ad</label>
                            <input type="text" class="form-control" id="first_name" name="first_name" 
                                   value="<?= $user_to_edit ? htmlspecialchars($user_to_edit['first_name']) : '' ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="last_name" class="form-label">Soyad</label>
                            <input type="text" class="form-control" id="last_name" name="last_name" 
                                   value="<?= $user_to_edit ? htmlspecialchars($user_to_edit['last_name']) : '' ?>" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="username" class="form-label">İstifadəçi Adı (Login)</label>
                        <input type="text" class="form-control" id="username" name="username" 
                               value="<?= $user_to_edit ? htmlspecialchars($user_to_edit['username']) : '' ?>" required>
                    </div>
                    
                    <div class="row">
                         <div class="col-md-6 mb-3">
                            <label for="role" class="form-label">Rol</label>
                            <select class="form-select" id="role" name="role" required>
                                <option value="waiter" <?= ($user_to_edit && $user_to_edit['role'] == 'waiter') ? 'selected' : '' ?>>Ofisiant</option>
                                <option value="admin" <?= ($user_to_edit && $user_to_edit['role'] == 'admin') ? 'selected' : '' ?>>Administrator</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="salary" class="form-label">Əmək haqqı (AZN)</label>
                            <input type="number" step="0.01" min="0" class="form-control" id="salary" name="salary" 
                                   value="<?= $user_to_edit ? htmlspecialchars($user_to_edit['salary']) : '0.00' ?>" required>
                        </div>
                    </div>


                    <div class="mb-3">
                        <label for="password" class="form-label">Şifrə <?= $user_to_edit ? ' (Dəyişdirmək istəmirsinizsə boş buraxın)' : '' ?></label>
                        <input type="password" class="form-control" id="password" name="password" 
                               <?= $user_to_edit && empty($user_to_edit['id']) ? 'required' : '' ?>>
                    </div>

                    <div class="mb-3 form-check form-switch">
                        <?php 
                            $is_active_checked = true;
                            if ($user_to_edit) {
                                $is_active_checked = (bool)$user_to_edit['is_active'];
                            }
                        ?>
                        <input type="checkbox" class="form-check-input" id="is_active" name="is_active" 
                               value="1" <?= $is_active_checked ? 'checked' : '' ?>
                               <?= ($user_to_edit && $user_to_edit['id'] == $_SESSION['user_id']) ? 'disabled' : '' ?>> 
                        <label class="form-check-label" for="is_active">İstifadəçi Aktivdir (İşləyir)</label>
                        <?php if ($user_to_edit && $user_to_edit['id'] == $_SESSION['user_id']): ?>
                            <small class="text-danger d-block">Öz aktiv statusunuzu burada dəyişdirə bilməzsiniz.</small>
                        <?php endif; ?>
                    </div>
                    
                    <div class="d-grid mt-3">
                        <button type="submit" class="btn btn-dark">
                            <i class="fas <?= $user_to_edit ? 'fa-edit' : 'fa-plus-circle' ?> me-2"></i>
                            <?= $user_to_edit ? 'Yadda Saxla' : 'İstifadəçini Əlavə Et' ?>
                        </button>
                    </div>
                    <?php if ($user_to_edit): ?>
                        <div class="d-grid mt-2">
                            <a href="users.php" class="btn btn-outline-secondary">Ləğv Et</a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-dark">Bütün İstifadəçilər</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Ad Soyad</th>
                                <th>İstifadəçi Adı</th>
                                <th>Rol</th>
                                <th>Maaş</th>
                                <th>Status</th>
                                <th>Qeydiyyat Tarixi</th>
                                <th>Əməliyyatlar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($users)): ?>
                                <?php foreach ($users as $user): ?>
                                    <tr>
                                        <td><?= $user['id'] ?></td>
                                        <td><?= htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) ?></td>
                                        <td><?= htmlspecialchars($user['username']) ?></td>
                                        <td>
                                            <?php 
                                            $role_class = ($user['role'] == 'admin') ? 'badge bg-primary' : 'badge bg-secondary';
                                            ?>
                                            <span class="<?= $role_class ?>"><?= ucfirst($user['role']) ?></span>
                                        </td>
                                        <td><?= number_format($user['salary'], 2) ?> AZN</td>
                                        
                                        <td>
                                            <?php
                                            $new_status = $user['is_active'] ? 0 : 1;
                                            $btn_class = $user['is_active'] ? 'btn-success' : 'btn-warning';
                                            $btn_icon = $user['is_active'] ? 'fa-check' : 'fa-times';
                                            $btn_text = $user['is_active'] ? 'Aktiv' : 'Deaktiv';
                                            $is_self = ($user['id'] == $_SESSION['user_id']);
                                            ?>
                                            <a href="users.php?action=toggle_status&id=<?= $user['id'] ?>&status=<?= $new_status ?>" 
                                               class="btn btn-sm <?= $btn_class ?> <?= $is_self ? 'disabled' : '' ?>"
                                               title="Statusu dəyişdir"
                                               onclick="return confirm('İstifadəçinin statusunu dəyişdirməyə əminsiniz?')">
                                                <i class="fas <?= $btn_icon ?>"></i> <?= $btn_text ?>
                                            </a>
                                        </td>
                                        
                                        <td><?= date('Y-m-d', strtotime($user['created_at'])) ?></td>
                                        <td>
                                            <a href="users.php?action=edit&id=<?= $user['id'] ?>" class="btn btn-sm btn-info me-2" title="Dəyişdir">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="users.php?action=delete&id=<?= $user['id'] ?>" 
                                               class="btn btn-sm btn-danger" 
                                               onclick="return confirm('İstifadəçi silinəcək. Əminsiniz?')"
                                               title="Sil"
                                               <?= $is_self ? 'disabled' : '' ?>>
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">Hələ heç bir istifadəçi əlavə edilməyib.</td>
                                 </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>