<?php
session_start();
$page_title = "Sistem Tənzimləmələri";
require_once '../includes/header.php'; 

// Yalnız Adminlər daxil ola bilər
if ($_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

// --- 1. Tənzimləmələri Yükləmək (READ) ---
$settings = [];
$result = $conn->query("SELECT `key`, `value`, `description` FROM settings");

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $settings[$row['key']] = [
            'value' => $row['value'],
            'description' => $row['description']
        ];
    }
} else if (!$result) {
    $error = "Tənzimləmələri yükləmək mümkün olmadı: " . $conn->error;
}


// --- 2. Tənzimləmələri Yadda Saxlamaq (UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1. Restoran Adı
    $restaurant_name = trim($_POST['restaurant_name']);
    // 2. Servis Faizi (Rəqəm olmalıdır)
    $service_fee_percent = (float)$_POST['default_service_fee_percent'];
    // 3. Afisiantın Komissiya Faizi (Rəqəm olmalıdır)
    $waiter_commission_percent = (float)$_POST['waiter_commission_percent'];
    
    $is_valid = true;
    
    if ($service_fee_percent < 0 || $waiter_commission_percent < 0) {
        $error = "Faiz dərəcələri mənfi ola bilməz.";
        $is_valid = false;
    }
    
    if ($is_valid) {
        // Tənzimləmələri dövr edib yeniləyirik
        $updates = [
            'restaurant_name' => $restaurant_name,
            'default_service_fee_percent' => $service_fee_percent,
            'waiter_commission_percent' => $waiter_commission_percent,
        ];
        
        $success = true;
        $conn->begin_transaction(); // Bütün əməliyyatların uğurlu olması üçün transaction istifadə edək
        
        foreach ($updates as $key => $value) {
            $stmt = $conn->prepare("UPDATE settings SET `value` = ? WHERE `key` = ?");
            // `value` TEXT olduğu üçün "s" (string) tipi istifadə olunur
            $stmt->bind_param("ss", $value, $key); 
            if (!$stmt->execute()) {
                $success = false;
                $error = "Tənzimləmə ($key) yenilənərkən xəta: " . $stmt->error;
                break;
            }
            $stmt->close();
        }
        
        if ($success) {
            $conn->commit();
            $message = "Sistem tənzimləmələri uğurla yadda saxlanıldı.";
        } else {
            $conn->rollback();
        }
    }
    
    header('Location: settings.php?message=' . urlencode($message) . '&error=' . urlencode($error));
    exit;
}

// Yaddaşda olan dəyərləri formaya yerləşdirmək üçün funksiya
function get_setting_value($settings, $key) {
    return htmlspecialchars($settings[$key]['value'] ?? '');
}

?>

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><i class="fas fa-check-circle me-2"></i> <?= htmlspecialchars($message) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-8 offset-lg-2">
        <div class="card shadow mb-4">
            <div class="card-header py-3" style="background-color: #ffc107; color: black;">
                <h6 class="m-0 font-weight-bold"><i class="fas fa-cog me-2"></i> Əsas Sistem Parametrləri</h6>
            </div>
            <div class="card-body">
                <form action="settings.php" method="POST">
                    
                    <div class="mb-4">
                        <label for="restaurant_name" class="form-label fw-bold">Restoranın Adı</label>
                        <input type="text" class="form-control" id="restaurant_name" name="restaurant_name" 
                               value="<?= get_setting_value($settings, 'restaurant_name') ?>" required>
                        <small class="text-muted"><?= $settings['restaurant_name']['description'] ?? '' ?></small>
                    </div>

                    <h5 class="mt-4 mb-3 text-primary"><i class="fas fa-percent me-2"></i> Faiz Tənzimləmələri</h5>
                    <hr>

                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <label for="default_service_fee_percent" class="form-label fw-bold">Servis Faizi (%)</label>
                            <div class="input-group">
                                <input type="number" step="0.01" min="0" class="form-control" id="default_service_fee_percent" 
                                       name="default_service_fee_percent" 
                                       value="<?= get_setting_value($settings, 'default_service_fee_percent') ?>" required>
                                <span class="input-group-text">%</span>
                            </div>
                            <small class="text-muted"><?= $settings['default_service_fee_percent']['description'] ?? '' ?></small>
                        </div>

                        <div class="col-md-6 mb-4">
                            <label for="waiter_commission_percent" class="form-label fw-bold">Afisiantın Komissiya Faizi (%)</label>
                            <div class="input-group">
                                <input type="number" step="0.01" min="0" class="form-control" id="waiter_commission_percent" 
                                       name="waiter_commission_percent" 
                                       value="<?= get_setting_value($settings, 'waiter_commission_percent') ?>" required>
                                <span class="input-group-text">%</span>
                            </div>
                            <small class="text-muted"><?= $settings['waiter_commission_percent']['description'] ?? '' ?></small>
                        </div>
                    </div>
                    
                    <div class="d-grid mt-4">
                        <button type="submit" class="btn btn-warning btn-lg">
                            <i class="fas fa-save me-2"></i> Tənzimləmələri Yadda Saxla
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>