<?php
session_start();
$page_title = "Satış Hesabatı";
require_once '../includes/header.php'; 
require_once '../config/db.php'; 

// Yalnız Adminlər daxil ola bilər
if ($_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

// --- Standart Tarix Filtrləmə (00:00:00 - 23:59:59) ---
$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date   = $_GET['end_date'] ?? date('Y-m-d');
$waiter_id  = $_GET['waiter_id'] ?? '';

$start_dt = $start_date . ' 00:00:00';
$end_dt   = $end_date   . ' 23:59:59';

// --- Ofisiant Siyahısı ---
$waiters = $conn->query("SELECT id, first_name, last_name FROM users WHERE role = 'waiter'")->fetch_all(MYSQLI_ASSOC);

// --- WHERE Şərtləri ---
// Ana cədvəl (orders) üçün
$where_orders = " WHERE o.status = 'paid' AND o.order_date BETWEEN '$start_dt' AND '$end_dt'";
if ($waiter_id != '') {
    $where_orders .= " AND o.waiter_id = " . (int)$waiter_id;
}

// --- 1. Ümumi Statistika (KPI) ---
// JOIN istifadə edirik ki, məhsul sayı da ofisiant filtrinə tabe olsun
$sql_kpi = "
    SELECT 
        SUM(o.total_amount) as grand_total,
        COUNT(DISTINCT o.id) as order_count,
        SUM(oi.quantity) as total_items_count
    FROM orders o
    LEFT JOIN order_items oi ON o.id = oi.order_id
    $where_orders";

$kpi_res = $conn->query($sql_kpi);
$kpi = $kpi_res->fetch_assoc();

// --- 2. Məhsul üzrə Detallı Satış Cədvəli ---
$sql_products = "
    SELECT 
        mi.name, 
        oi.price_at_order,
        SUM(oi.quantity) as total_qty, 
        SUM(oi.price_at_order * oi.quantity) as total_revenue
    FROM order_items oi
    JOIN orders o ON oi.order_id = o.id
    JOIN menu_items mi ON oi.menu_item_id = mi.id
    $where_orders
    GROUP BY mi.id, oi.price_at_order
    ORDER BY total_qty DESC";
$products = $conn->query($sql_products);
?>

<div class="container py-4">
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-body">
            <h5 class="fw-bold mb-3"><i class="fas fa-filter me-2 text-primary"></i>Hesabat Filtri</h5>
            <form method="GET" class="row g-2">
                <div class="col-md-3">
                    <label class="small text-muted fw-bold">Başlanğıc Tarixi</label>
                    <input type="date" name="start_date" class="form-control" value="<?= $start_date ?>">
                </div>
                <div class="col-md-3">
                    <label class="small text-muted fw-bold">Bitiş Tarixi</label>
                    <input type="date" name="end_date" class="form-control" value="<?= $end_date ?>">
                </div>
                <div class="col-md-3">
                    <label class="small text-muted fw-bold">Ofisiant Seçin</label>
                    <select name="waiter_id" class="form-select">
                        <option value="">Hamısı (Bütün Restoran)</option>
                        <?php foreach($waiters as $w): ?>
                            <option value="<?= $w['id'] ?>" <?= $waiter_id == $w['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($w['first_name'].' '.$w['last_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 fw-bold">HESABATI YENİLƏ</button>
                </div>
            </form>
        </div>
    </div>

    <div class="row g-3 mb-4 text-center">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm bg-primary text-white p-4">
                <div class="small opacity-75 fw-bold text-uppercase">Ümumi Kassa</div>
                <div class="h2 fw-bold mb-0"><?= number_format($kpi['grand_total'] ?? 0, 2) ?> ₼</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm bg-success text-white p-4">
                <div class="small opacity-75 fw-bold text-uppercase">Satılan Məhsul Sayı</div>
                <div class="h2 fw-bold mb-0"><?= (int)($kpi['total_items_count'] ?? 0) ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm bg-dark text-white p-4">
                <div class="small opacity-75 fw-bold text-uppercase">Sifariş (Qəbz) Sayı</div>
                <div class="h2 fw-bold mb-0"><?= (int)($kpi['order_count'] ?? 0) ?></div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-header bg-white py-3 border-bottom d-flex justify-content-between align-items-center">
            <h6 class="mb-0 fw-bold text-secondary"><i class="fas fa-utensils me-2"></i>Məhsul Bazlı Satış Detalları</h6>
            <span class="badge bg-light text-dark border"><?= date('d.m.Y', strtotime($start_date)) ?> - <?= date('d.m.Y', strtotime($end_date)) ?></span>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-3">Məhsul Adı</th>
                            <th class="text-center">Vahid Qiymət</th>
                            <th class="text-center">Miqdar</th>
                            <th class="text-end pe-3">Ümumi Məbləğ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($products && $products->num_rows > 0): ?>
                            <?php while($row = $products->fetch_assoc()): ?>
                                <tr>
                                    <td class="ps-3 fw-bold"><?= htmlspecialchars($row['name']) ?></td>
                                    <td class="text-center"><?= number_format($row['price_at_order'], 2) ?> ₼</td>
                                    <td class="text-center">
                                        <span class="badge rounded-pill bg-info text-dark px-3"><?= $row['total_qty'] ?></span>
                                    </td>
                                    <td class="text-end pe-3 fw-bold text-primary">
                                        <?= number_format($row['total_revenue'], 2) ?> ₼
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="4" class="text-center py-5 text-muted">
                                    <i class="fas fa-folder-open fa-3x mb-3 d-block opacity-25"></i>
                                    Seçilmiş kriteriyalara uyğun ödənişli sifariş tapılmadı.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>