<?php
session_start();
$page_title = "Silinmiş Məhsullar Jurnalı";
require_once '../includes/header.php'; 
require_once '../config/db.php'; 

if ($_SESSION['role'] !== 'waiter' && $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

$waiter_id = $_SESSION['user_id'];

// --- Tarix Aralığını Təyin Etmək ---
$today = date('Y-m-d');
$default_start = date('Y-m-d'); // Default olaraq cari gün
$start_date = $_GET['start_date'] ?? $default_start;
$end_date = $_GET['end_date'] ?? $today;

// Tarix yoxlaması
$start_dt = $start_date . ' 00:00:00';
$end_dt = $end_date . ' 23:59:59';


$deletions = [];
$error = '';

try {
    // Admin hər kəsin silinmələrini görə bilər
    if ($_SESSION['role'] === 'admin') {
        // Tarix filtri tətbiq olunur
        $sql = "
            SELECT 
                doi.delete_date, doi.table_number, doi.menu_item_name, doi.quantity, doi.price_at_delete, doi.order_id, 
                u.first_name, u.last_name
            FROM deleted_order_items doi
            JOIN users u ON doi.waiter_id = u.id
            WHERE doi.delete_date BETWEEN ? AND ? 
            ORDER BY doi.delete_date DESC
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ss", $start_dt, $end_dt);
        
    } else {
        // Ofisiant yalnız öz silinmələrini görür, lakin tarix aralığını seçə bilər
        $sql = "
            SELECT 
                doi.delete_date, doi.table_number, doi.menu_item_name, doi.quantity, doi.price_at_delete, doi.order_id, 
                u.first_name, u.last_name
            FROM deleted_order_items doi
            JOIN users u ON doi.waiter_id = u.id
            WHERE doi.waiter_id = ? AND doi.delete_date BETWEEN ? AND ?
            ORDER BY doi.delete_date DESC
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iss", $waiter_id, $start_dt, $end_dt);
    }

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        $deletions = $result->fetch_all(MYSQLI_ASSOC);
    } else {
        throw new Exception("SQL icrasında xəta: " . $stmt->error);
    }
    $stmt->close();

} catch (Exception $e) {
    $error = "Məlumat yüklənərkən xəta: " . $e->getMessage();
}

?>

<div class="container-fluid py-4">
    <h1 class="mb-4">
        <i class="fas fa-trash-alt text-danger me-2"></i> 
        Silinmiş Məhsullar Jurnalı
    </h1>
    
    <?php if ($error): ?>
        <div class="alert alert-danger mb-4"><i class="fas fa-exclamation-triangle me-2"></i> <?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-body">
            <form method="GET" action="deletion_log.php">
                <div class="row align-items-end">
                    <div class="col-md-4 mb-3">
                        <label for="start_date" class="form-label">Başlanğıc Tarixi:</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label for="end_date" class="form-label">Bitiş Tarixi:</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-2"></i> Jurnalı Axtar
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <h5 class="mb-3">
        Göstərilən Dövr: <span class="badge bg-secondary"><?= date('d.m.Y', strtotime($start_date)) ?> - <?= date('d.m.Y', strtotime($end_date)) ?></span>
    </h5>


    <div class="card shadow">
        <div class="card-header bg-danger text-white">
            <h5 class="m-0"><i class="fas fa-exclamation-triangle me-1"></i> İzlənilən Məhsul Silinmələri</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <?php if (empty($deletions)): ?>
                    <p class="text-center text-muted p-4 mb-0">
                        Seçilmiş dövrdə silinmiş məhsul qeydi tapılmadı.
                    </p>
                <?php else: ?>
                    <table class="table table-striped table-hover mb-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Tarix/Vaxt</th>
                                <th>Masa</th>
                                <th>Məhsul Adı</th>
                                <th>Miqdar</th>
                                <th>Ümumi Qiymət</th>
                                <th>Sifariş ID</th>
                                <?php if ($_SESSION['role'] === 'admin'): ?>
                                    <th>Ofisiant</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; foreach ($deletions as $item): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= date('d.m.Y H:i:s', strtotime($item['delete_date'])) ?></td>
                                    <td>**<?= htmlspecialchars($item['table_number']) ?>**</td>
                                    <td><?= htmlspecialchars($item['menu_item_name']) ?></td>
                                    <td><span class="badge bg-danger"><?= $item['quantity'] ?></span></td>
                                    <td><?= number_format($item['price_at_delete'] * $item['quantity'], 2) ?> AZN</td>
                                    <td><a href="order_view.php?order_id=<?= $item['order_id'] ?>" class="text-primary">#<?= $item['order_id'] ?></a></td>
                                    <?php if ($_SESSION['role'] === 'admin'): ?>
                                        <td><?= htmlspecialchars($item['first_name'] . ' ' . $item['last_name']) ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>