<?php
// Session yoxlaması
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// DB qoşulması
if (!isset($conn)) {
    require_once '../config/db.php';
}

$page_title = $page_title ?? "Dashboard";
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="az">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>POS Menyum.az | <?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link rel="stylesheet" href="../style.css"> 
    <style>
        .navbar {
            border-bottom: 4px solid #dee2e6 !important;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm mb-4">
    <div class="container-fluid px-4">
        <a class="navbar-brand text-primary fw-bold" href="<?= ($_SESSION['role'] == 'admin' ? 'index.php' : '../waiter/index.php') ?>">
            <i class="fas fa-cash-register me-2"></i>Pos Menyum.az
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <?php if ($_SESSION['role'] == 'admin'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?= ($current_page == 'index.php' || $current_page == '') ? 'active' : '' ?>" href="/restoran_pos/admin/index.php">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= ($current_page == 'menu.php') ? 'active' : '' ?>" href="/restoran_pos/waiter/index.php">Masalar (Nəzarət)</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= ($current_page == 'tables.php') ? 'active' : '' ?>" href="/restoran_pos/admin/tables.php">Masalar</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= ($current_page == 'categories.php') ? 'active' : '' ?>" href="/restoran_pos/admin/categories.php">Kateqoriyalar</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= ($current_page == 'menu.php') ? 'active' : '' ?>" href="/restoran_pos/admin/menu.php">Menyu Məhsulları</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/restoran_pos/admin/users.php">İstifadəçilər</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/restoran_pos/admin/reports.php">
                            Hesabatlar
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link " href="/restoran_pos/admin/settings.php">Tənzimləmələr</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/restoran_pos/waiter/deletion_log.php">
                            <i class="fas fa-trash-alt me-2 text-danger"></i> Silinmə Jurnalı
                        </a>
                    </li>
                <?php endif; ?>
            </ul>

            <ul class="navbar-nav">
                 <li class="nav-item me-3 text-dark d-flex align-items-center">
                    <i class="fas fa-user-circle me-1"></i> 
                    <?= htmlspecialchars($_SESSION['username']) ?> 
                    <span class="badge bg-secondary ms-2"><?= strtoupper($_SESSION['role']) ?></span>
                </li>
                <li class="nav-item">
                    <a class="btn btn-outline-danger btn-sm" href="../logout.php">
                        <i class="fas fa-sign-out-alt me-1"></i> Çıxış
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<br>

<!-- <div class="container-fluid main-content-area">
    <h1 class="mb-4 page-heading"><?= $page_title ?></h1>
</div>  -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
<?php 
// DB qoşulması bağlanması (Artıq müzakirə etdiyimiz kimi)
// if (isset($conn)) {
//     $conn->close();
// }
?>