<?php
include '../connect.php';
//
function sanitize_output($buffer) {
    $search = array(
        '/\>[^\S ]+/s',     // strip whitespaces after tags, except space
        '/[^\S ]+\</s',     // strip whitespaces before tags, except space
        '/(\s)+/s',         // shorten multiple whitespace sequences
        '/<!--(.|\s)*?-->/' // Remove HTML comments
    );
    $replace = array(
        '>',
        '<',
        '\\1',
        ''
    );
    $buffer = preg_replace($search, $replace, $buffer);
    return $buffer;
}
ob_start("sanitize_output");
//
?>
<!DOCTYPE html>
<html lang="en">
    <!-- BEGIN: Head -->
    <head>
        <meta charset="utf-8">
        <link href="dist/images/logo.svg" rel="shortcut icon">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?=$a_tr_0?></title>
        <!-- BEGIN: CSS Assets-->
        <link rel="stylesheet" href="<?=$site_url?>dist/css/style.css" />
        <!-- END: CSS Assets-->
    </head>
    <!-- END: Head -->
    <body class="login">
        <div class="container sm:px-10">
            <div class="block xl:grid grid-cols-2 gap-4">
                <!-- BEGIN: Register Info -->
                <!-- BEGIN: Login Info -->
                <div class="hidden xl:flex flex-col min-h-screen">
                    <a href="" class="-intro-x flex items-center pt-5">
                        <!--<img alt="Midone Tailwind HTML Admin Template" class="w-6" src="dist/images/logo.png">-->
                        <span class="text-white text-lg ml-3"> WCU<span class="font-medium">.edu.az</span> </span>
                    </a>
                    <div class="my-auto">
                        <img alt="Midone Tailwind HTML Admin Template" class="-intro-x w-1/2 -mt-16" src="<?=$site_url?>dist/images/illustration.svg">
                        <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">
                          <?=$a_tr_1?>
                        </div>
                        <div class="-intro-x mt-5 text-lg text-white dark:text-gray-500">
                        <?=$a_tr_2?>
                        </div>
                    </div>
                </div>
                <!-- END: Register Info -->
                <!-- BEGIN: Register Form -->
<div class="h-screen xl:h-auto flex py-5 xl:py-0 my-8 xl:my-0">
<div class="my-auto mx-auto xl:ml-20 bg-white xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">


<?php
if(!empty($_GET['type'])){
  $type = mysqli_real_escape_string($conn, strip_tags(trim($_GET['type'])));
  if($type=='University'){
    $sql = " `kollec_or_uni`='University' ";
  }else{
    $sql = " `kollec_or_uni`='Kollec' ";
  }
}else{
  $type = 'Kollec';
  $sql = " `kollec_or_uni`='Kollec' ";
}

if(isset($_POST['register']))
{

//


  $first_name    = mysqli_real_escape_string($conn, strip_tags(trim($_POST['first_name'])));
  $last_name     = mysqli_real_escape_string($conn, strip_tags(trim($_POST['last_name'])));
  $father_name   = mysqli_real_escape_string($conn, strip_tags(trim($_POST['father_name'])));
  $group_id      = mysqli_real_escape_string($conn, strip_tags(trim($_POST['group_id'])));
  $kollec_or_uni = mysqli_real_escape_string($conn, strip_tags(trim($_POST['kollec_or_uni'])));
  if($kollec_or_uni!='University'){$kollec_or_uni=='Kollec';}


  $email = mb_strtolower(mysqli_real_escape_string($conn, strip_tags(trim($_POST['email']))), 'utf-8');
  $passsen = mysqli_real_escape_string($conn, strip_tags(trim($_POST['pass1'])));
  $pass1 = sha1(md5(mysqli_real_escape_string($conn, strip_tags(trim($_POST['pass1'])))));
  $pass2 = sha1(md5(mysqli_real_escape_string($conn, strip_tags(trim($_POST['pass2'])))));
  //


   if(!checkemail($email))
  {
	  $flash = $a_tr_5;
	  $alert = 'bg-theme-6';
  }
  else
  {
  	 if($pass1==$pass2)
  	 {
        $password1 = strip_tags(trim($_POST["pass1"]));
        $length = strlen($password1);
	    if($length < 6 || $length > 16)
	    {
	    	$flash = $a_tr_6;
	        $alert = 'bg-theme-6';
	    }
	    else
	    {

$emaili_yoxla = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM `students` WHERE LOWER(`email`)='$email';"));

          //
			    if(!$emaili_yoxla)
			    {
			    //
			    $insert = mysqli_query($conn, "INSERT INTO `students` (`id`, `first_name`, `last_name`, `father_name`, `fin_code`, `sex`, `birthday`, `image`, `phone`, `parent_phone_number`, `email`, `password`, `group_id`, `department_id`, `speciality_id`, `note`, `tehsil_9_or_11`, `join_date`, `education_price`, `kollec_or_uni`, `added_date`, `update_date`) VALUES (NULL, '$first_name', '$last_name', '$father_name', '0', '0', '0', '', '0', '0', '$email', '$pass1', '$group_id', '0', '0', '0', '0', '0', '0', '$kollec_or_uni', current_timestamp(), current_timestamp());");
			    //
			    if($insert)
			    {
            //
            //
			      $flash = $a_tr_7;
			      $alert = 'bg-theme-9';
			      //
			      $_SESSION['login_worker'] = 'success';
			      $_SESSION['first_name']   = $first_name;
			      $_SESSION['last_name']    = $last_name;
			      $_SESSION['father_name']  = $father_name;
			      $_SESSION['email']        = $email;
			      $_SESSION['phone']        = $phone;
			      //
			      yonlendir($site_url,"500");
			      //
			    }
			    else
			    {
			      //
			      $flash = $a_tr_8;
			      $alert = 'bg-theme-6';
			      //
			    }
			  }
			  else
			  {
	                if($email==$emaili_yoxla['email'])
	                {
				    //
				      $flash = $a_tr_9;
				      $alert = 'bg-theme-6';
				    //
	                }

			  }
	    }
  	 }
  	 else
  	 {
  	 	$flash = $a_tr_12;
        $alert = 'bg-theme-6';
  	 }
  }

}
?>



<?php if (!empty($flash)): ?>
  <div class="rounded-md px-5 py-4 mb-2 <?=$alert?> text-white"><?=$flash?></div>
<?php endif; ?>


<h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left"><?=$a_tr_15?></h2>

<form class="" action="" method="post" autocomplete="off">
<div class="intro-x mt-8">
<input type="text" name="first_name" required class="intro-x login__input w-full input input--lg border border-gray-300 block" placeholder="<?=$a_tr_16?>"  autocomplete="off">
<input type="text" name="last_name" required class="intro-x login__input w-full input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_17?>"  autocomplete="off">
<input type="text" name="father_name" required class="intro-x login__input w-full input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_18?>"  autocomplete="off">















<div class="mt-4">
<select name="group_id" class="intro-x login__input input w-full input--lg border border-gray-300 block select2" required>
<option value=""><?=$a_tr_22?></option>
<?php
$query = mysqli_query($conn, "SELECT * FROM `groups` WHERE $sql ORDER BY `id` DESC");
if(@mysqli_num_rows($query)>'0'){
while($rows = mysqli_fetch_array($query)){
?>
<option value="<?=$rows['id'];?>"><?=$rows['name'];?></option>
<?php } } ?>
</select>
</div>








<span style="font-size:10px;margin-top:5px;" class=" mt-4"><?=$a_tr_30?></span>
<input type="email" name="email" required class="intro-x w-full login__input input input--lg border border-gray-300 block" placeholder="<?=$a_tr_31?>"  autocomplete="off">
<input type="password" name="pass1" required class="intro-x w-full login__input input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_32?>"  autocomplete="off">
<input type="password" name="pass2" required class="intro-x w-full login__input input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_33?>"  autocomplete="off">




<div class="mt-4">
<div class="flex items-center text-gray-700 dark:text-gray-500 mt-2">
<input type="radio" checked class="intro-x input border mr-2" id="kollec" name="kollec_or_uni" value="Kollec">
<label class="cursor-pointer select-none" for="kollec"><?=$a_tr_38?></label>
</div>
</div>


</div>
<div class="intro-x mt-5 xl:mt-8 text-center xl:text-left qeydiyyat_ol_here">
<button type="submit" name="register" value="ok" class="button qeydiyyat_ol button--lg w-full xl:w-32 text-white bg-theme-1 xl:mr-3">OK</button>
</div>
</form>

                    </div>
                </div>
                <!-- END: Register Form -->
            </div>
        </div>

        <!--<script src="<?=$site_url?>dist/js/app.js"></script>-->
    </body>
</html>




<script src="<?=$site_url?>dist/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript">
$('.datepicker').val('');
</script>




<script src="<?=$site_url?>dist/js/jquery.inputmask.bundle.js"></script>
<script id="rendered-js">
$(document).on('click','.qeydiyyat_ol',function(){

$(this).attr('disabled');

setTimeout(function(){
  $(this).removeAttr('disabled');
}, 3000);



});

$(document).on('click keyup change','.phone',function(){
  $(".phone").inputmask({
    mask:[{mask:"(###) ###-##-##"}],
    greedy:!1,
    definitions:{"#":{validator:"[0-9]",cardinality:1}}
  })
});
</script>
