<?php
include '../connect.php';
//
function sanitize_output($buffer) {
    $search = array(
        '/\>[^\S ]+/s',     // strip whitespaces after tags, except space
        '/[^\S ]+\</s',     // strip whitespaces before tags, except space
        '/(\s)+/s',         // shorten multiple whitespace sequences
        '/<!--(.|\s)*?-->/' // Remove HTML comments
    );
    $replace = array(
        '>',
        '<',
        '\\1',
        ''
    );
    $buffer = preg_replace($search, $replace, $buffer);
    return $buffer;
}
ob_start("sanitize_output");
//
?>
<!DOCTYPE html>
<html lang="en">
    <!-- BEGIN: Head -->
    <head>
        <meta charset="utf-8">
        <link href="dist/images/logo.svg" rel="shortcut icon">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?=$a_tr_40?></title>
        <!-- BEGIN: CSS Assets-->
        <link rel="stylesheet" href="<?=$site_url?>dist/css/style.css" />
        <!-- END: CSS Assets-->
        <style>
        	.font
        	{
        		font-size:10px;
        	}
        </style>
    </head>
    <!-- END: Head -->
    <body class="login">
        <div class="container sm:px-10">
            <div class="block xl:grid grid-cols-2 gap-4">
                <!-- BEGIN: Register Info -->
                <!-- BEGIN: Login Info -->
                <div class="hidden xl:flex flex-col min-h-screen">
                    <a href="" class="-intro-x flex items-center pt-5">
                        <!--<img alt="Midone Tailwind HTML Admin Template" class="w-6" src="dist/images/logo.png">-->
                        <span class="text-white text-lg ml-3"> WCU<span class="font-medium">.edu.az</span> </span>
                    </a>
                    <div class="my-auto">
                        <img alt="Midone Tailwind HTML Admin Template" class="-intro-x w-1/2 -mt-16" src="<?=$site_url?>dist/images/illustration.svg">
                        <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">
                            <?=$a_tr_1?>
                        </div>
                        <div class="-intro-x mt-5 text-lg text-white dark:text-gray-500">
                            <?=$a_tr_40?>
                        </div>
                    </div>
                </div>
                <!-- END: Register Info -->
                <!-- BEGIN: Register Form -->
<div class="h-screen xl:h-auto flex py-5 xl:py-0 my-8 xl:my-0">
<div class="my-auto mx-auto xl:ml-20 bg-white xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">


<?php
if(isset($_POST['register']))
{
  if (isset($_POST['g-recaptcha-response'])) {
  //
  $secret = '6LfcEs8ZAAAAAK3kVdHOiQlENb5VuFH7o3dwjNcJ';
  $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$_POST['g-recaptcha-response']);
  $responseData = json_decode($verifyResponse);
  if($responseData->success){
  //


  $first_name  = mysqli_real_escape_string($conn, strip_tags(trim($_POST['first_name'])));
  $last_name   = mysqli_real_escape_string($conn, strip_tags(trim($_POST['last_name'])));
  $father_name = mysqli_real_escape_string($conn, strip_tags(trim($_POST['father_name'])));
  $phone       = mysqli_real_escape_string($conn, strip_tags(trim($_POST['phone'])));
  $bakalavr_or_magistr  = mysqli_real_escape_string($conn, strip_tags(trim($_POST['bakalavr_or_magistr'])));
  $email       = mb_strtolower(mysqli_real_escape_string($conn, strip_tags(trim($_POST['email']))), 'utf-8');
  $sex         = mysqli_real_escape_string($conn, strip_tags(trim($_POST['sex'])));
  $passsen     = mysqli_real_escape_string($conn, strip_tags(trim($_POST['pass1'])));
  $pass1       = sha1(md5(mysqli_real_escape_string($conn, strip_tags(trim($_POST['pass1'])))));
  $pass2       = sha1(md5(mysqli_real_escape_string($conn, strip_tags(trim($_POST['pass2'])))));
  //

  if($first_name == "" || $last_name == "" || $father_name == "" || $phone == "" || $email == "" || $sex == "" || $pass1 == "" || $pass2 == "" || $bakalavr_or_magistr == "")
  {
      $flash =   $a_tr_3;
      $alert = 'bg-theme-6';
  }
  elseif(!checkemail($email))
  {
     $flash =   $a_tr_5;
     $alert = 'bg-theme-6';
  }
  else if($pass1!=$pass2)
  {
  	 $flash =   $a_tr_12;
     $alert = 'bg-theme-6';
  }
  else
  {
     $pass = strip_tags(trim($_POST["pass1"]));
     $length = strlen($pass);

     if($length < 6 || $length > 16)
     {
        $flash =   $a_tr_6;
        $alert = 'bg-theme-6';
     }
     else
     {
     	$emaili_yoxla = mysqli_fetch_array(mysqli_query($conn, "SELECT `id` FROM `students` WHERE LOWER(`email`)='$email';"));
     	if(!$emaili_yoxla)
     	{
     		$insert = mysqli_query($conn, "INSERT INTO `students` (`id`, `subbakalavr`, `first_name`, `last_name`, `father_name`, `sex`, `phone`, `email`, `bakalavr_or_magistr`, `password`, `status`, `added_date`, `update_date`) VALUES (NULL, '1', '$first_name', '$last_name', '$father_name', '$sex', '$phone', '$email', '$bakalavr_or_magistr', '$pass1', '-1' , current_timestamp(), current_timestamp());");
     		if($insert)
     		{
     			$flash =   $a_tr_7;
		        $alert = 'bg-theme-9';


            //
            require("class.phpmailer.php");
            $message = '
            Salam, '.$first_name.' '.$last_name.'!
            <br>
            <br>
            Siz Qərbi Kaspi Universitetinin '.$bakalavr_or_magistr.' qeydiyyatını uğurlu şəkildə tamamladınız.
            <br>
            <br>
            Email: <i>'.$email.'</i>
            <br>
            Şifrə: <i>'.$passsen.'</i>
            <br>
            <br>
            Şəxsi kabinetə daxil olub sənədləri yükləmək üçün url: <a href="'.$site_url.'">'.$site_url.'</a>
            ';
            $mail = new PHPMailer();
            $mail->IsSMTP();
            $mail->SMTPDebug = 1;
            $mail->SMTPAuth = true;
$mail->SMTPSecure = 'tsl';
$mail->Host = "hostru07.fornex.host";
$mail->Port = 25; // or 587
$mail->IsHTML(true);
$mail->SetLanguage("az", "phpmailer/language");
$mail->CharSet  ="utf-8";
$mail->Username = "support@my.wcu.edu.az"; // Mail adresi
$mail->Password = "cR7dR3kMcR7dR3kM"; // Parola
            $mail->SetFrom("support@my.wcu.edu.az", "Qərbi Kaspi Universiteti"); // Mail adresi
            $mail->AddAddress($email); // Gönderilecek kişi
            $mail->Subject = 'Qərbi Kaspi Universiteti | '.$bakalavr_or_magistr.' qeydiyyatı';
            $mail->Body = $message;
            $mail->Send();
            //
            $flash = 'Qeydiyyat uğurla başa çatdı!';
            $alert = 'bg-theme-9';
            //
            $_SESSION['login_worker'] = 'success';
            $_SESSION['first_name']   = $first_name;
            $_SESSION['last_name']    = $last_name;
            $_SESSION['father_name']  = $father_name;
            $_SESSION['email']        = $email;
            $_SESSION['phone']        = $phone;
            //
		        yonlendir($site_url, "3000");
     		}
     		else
     		{
		        $flash =   $a_tr_8;
		        $alert = 'bg-theme-6';
     		}
     	}
     	else
     	{
		    $flash =    $a_tr_9;
		    $alert = 'bg-theme-6';
     	}
     }
  }
}else{
  $flash =   $a_tr_13;
  $alert = 'bg-theme-6';
}
}else{
  $flash =   $a_tr_13;
  $alert = 'bg-theme-6';
}
}

?>



<?php if (!empty($flash)): ?>
  <div class="rounded-md px-5 py-4 mb-2 <?=$alert?> text-white"><?=$flash?></div>
<?php endif; ?>


<h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left"><?=$a_tr_15?></h2>

<form class="" action="" method="post" autocomplete="off">
<div class="intro-x mt-8">
<input type="text" name="first_name" required class="intro-x login__input w-full input input--lg border border-gray-300 block" placeholder="<?=$a_tr_41?>" autocomplete="off">
<span class="font"><?=$a_tr_48?></span>
<input type="text" name="last_name" required class="intro-x login__input w-full input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_42?>" autocomplete="off">
<span class="font"><?=$a_tr_49?></span>
<input type="text" name="father_name" required class="intro-x login__input w-full input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_43?>" autocomplete="off">
<span class="font"><?=$a_tr_50?></span>
<select class="intro-x login__input input input--lg w-full border border-gray-300 block mt-4" name="sex" required>
  <option value=""><?=$a_tr_34?></option>
  <option value="1"><?=$a_tr_35?></option>
  <option value="0"><?=$a_tr_36?></option>
</select>
<input type="text" name="phone" required class="intro-x w-full login__input input input--lg border border-gray-300 block mt-4 phone" placeholder="<?=$a_tr_44?>" autocomplete="off">
<span class="font"><?=$a_tr_51?></span>
<input type="email" name="email" required class="intro-x w-full login__input input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_45?>" autocomplete="off">
<span class="font"><?=$a_tr_52?></span>
<input type="password" name="pass1" required class="intro-x w-full login__input input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_46?>" autocomplete="off">
<span class="font"><?=$a_tr_53?></span>
<input type="password" name="pass2" required class="intro-x w-full login__input input input--lg border border-gray-300 block mt-4" placeholder="<?=$a_tr_47?>" autocomplete="off">
<span class="font"><?=$a_tr_53?></span>
<select class="intro-x login__input input input--lg w-full border border-gray-300 block mt-4" name="bakalavr_or_magistr" required>
  <option value=""><?=$a_tr_54?></option>
  <option value="Bakalavr"><?=$a_tr_55?></option>
  <option value="Subbakalavr"><?=$a_tr_56?></option>
  <option value="Magistr"><?=$a_tr_57?></option>
</select>
</div>
<div class="mt-4">
  <div class="g-recaptcha" data-sitekey="6LfcEs8ZAAAAAMYGKxtvbNB-DMHTNuxCKrdsH9s7"></div>
</div>
<div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
<button type="submit" name="register" value="ok" class="button button--lg w-full xl:w-32 text-white bg-theme-1 xl:mr-3"><?=$a_tr_39?></button>
</div>
</form>

                    </div>
                </div>
                <!-- END: Register Form -->
            </div>
        </div>
        <!-- BEGIN: Dark Mode Switcher-->
        <!-- END: Dark Mode Switcher-->
        <!--
        <script src="<?=$site_url?>dist/js/app.js"></script>
        -->
    </body>
</html>



<script src='https://www.google.com/recaptcha/api.js'></script>
<script src="<?=$site_url?>dist/js/jquery-3.3.1.min.js"></script>
<script src="<?=$site_url?>dist/js/jquery.inputmask.bundle.js"></script>
<script type="text/javascript">
$('.datepicker').val('');

$(document).on('click keyup change','.phone',function(){
  $(".phone").inputmask({
    mask:[{mask:"(###) ###-##-##"}],
    greedy:!1,
    definitions:{"#":{validator:"[0-9]",cardinality:1}}
  })
});

</script>

