<?php
include '../connect.php';
//
function sanitize_output($buffer) {
    $search = array(
        '/\>[^\S ]+/s',     // strip whitespaces after tags, except space
        '/[^\S ]+\</s',     // strip whitespaces before tags, except space
        '/(\s)+/s',         // shorten multiple whitespace sequences
        '/<!--(.|\s)*?-->/' // Remove HTML comments
    );
    $replace = array(
        '>',
        '<',
        '\\1',
        ''
    );
    $buffer = preg_replace($search, $replace, $buffer);
    return $buffer;
}
ob_start("sanitize_output");
//
?>
<!DOCTYPE html>
<html lang="en">
<!-- BEGIN: Head -->
<head>
    <meta charset="utf-8">
    <link href="dist/images/logo.svg" rel="shortcut icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>   <?=$a_tr_58?></title>
    <!-- BEGIN: CSS Assets-->
    <link rel="stylesheet" href="<?=$site_url?>dist/css/style.css" />
    <!-- END: CSS Assets-->
    <style>
        .font
        {
            font-size:10px;
        }
    </style>
</head>
<!-- END: Head -->
<body class="login">
<div class="container sm:px-10">
    <div class="block xl:grid grid-cols-2 gap-4">
        <!-- BEGIN: Register Info -->
        <!-- BEGIN: Login Info -->
        <div class="hidden xl:flex flex-col min-h-screen">
            <a href="" class="-intro-x flex items-center pt-5">
                <!--<img alt="Midone Tailwind HTML Admin Template" class="w-6" src="dist/images/logo.png">-->
                <span class="text-white text-lg ml-3"> WCU<span class="font-medium">.edu.az</span> </span>
            </a>
            <div class="my-auto">
                <img alt="Midone Tailwind HTML Admin Template" class="-intro-x w-1/2 -mt-16" src="<?=$site_url?>dist/images/illustration.svg">
                <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">
                    <?=$a_tr_1?>
                </div>
                <div class="-intro-x mt-5 text-lg text-white dark:text-gray-500">
                    <?=$a_tr_59?>
                </div>
            </div>
        </div>
        <!-- END: Register Info -->
        <!-- BEGIN: Register Form -->
        <div class="h-screen xl:h-auto flex py-5 xl:py-0 my-8 xl:my-0">
            <div class="my-auto mx-auto xl:ml-20 bg-white xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">


                <?php

                if(isset($_POST['graduate_add']))
                {
                    $first_name       = mysqli_real_escape_string($conn, strip_tags(trim($_POST['first_name'])));
                    $last_name        = mysqli_real_escape_string($conn, strip_tags(trim($_POST['last_name'])));
                    $father_name      = mysqli_real_escape_string($conn, strip_tags(trim($_POST['father_name'])));
                    $phone            = mysqli_real_escape_string($conn, strip_tags(trim($_POST['phone'])));
                    $email            = mb_strtolower(mysqli_real_escape_string($conn, strip_tags(trim($_POST['email']))),'utf-8');
                    $country_live     = mysqli_real_escape_string($conn, strip_tags(trim($_POST['country_live'])));
                    $specialty        = mysqli_real_escape_string($conn, strip_tags(trim($_POST['specialty'])));
                    $graduate_year    = mysqli_real_escape_string($conn, strip_tags(trim($_POST['graduate_year'])));
                    $work_location    = mysqli_real_escape_string($conn, strip_tags(trim($_POST['work_location'])));
                    $position         = mysqli_real_escape_string($conn, strip_tags(trim($_POST['position'])));
                    $work_phone       = mysqli_real_escape_string($conn, strip_tags(trim($_POST['work_phone'])));
                    $education_degree = mysqli_real_escape_string($conn, strip_tags(trim($_POST['education_degree'])));
                    $university_about = mysqli_real_escape_string($conn, strip_tags(trim($_POST['university_about'])));
                    $groupNo          = mysqli_real_escape_string($conn, strip_tags(trim($_POST['groupNo'])));
                    $education_forma  = mysqli_real_escape_string($conn, strip_tags(trim($_POST['education_forma'])));
                    //

                    $fullname = $last_name." ".$first_name." ".$father_name;

                    $insert = mysqli_query($conn, "INSERT INTO `graduates` (`id`, `fullname`, `email`, `tel`, `country`, `specialty`, `groupNo`, `tehsil_formasi`, `tehsil_derecesi`, `mezun_ili`, `workplace`, `duty`, `work_number`, `note`, `added_date`, `update_date`) VALUES (NULL, '$fullname', '$email', '$phone', '$country_live', '$specialty', '$groupNo','$education_forma', '$education_degree', '$graduate_year', '$work_location', '$position' , '$work_phone' ,'$university_about', current_timestamp(), current_timestamp());");
                    if($insert)
                    {
                        $flash = 'Qeydiyyat uğurla başa çatdı!';
                        $alert = 'bg-theme-9';

                        $_SESSION['login_worker'] = 'success';
                        //$_SESSION['first_name']   = $first_name;
                        //$_SESSION['last_name']    = $last_name;
                        //$_SESSION['father_name']  = $father_name;
                        //$_SESSION['email']        = $email;
                        //$_SESSION['phone']        = $phone;

                        // yonlendir($site_url, "3000");
                    }
                    else
                    {
                        $flash = $a_tr_8;
                        $alert = 'bg-theme-6';
                    }
                }

                ?>


                <?php if (!empty($flash)): ?>
                    <div class="rounded-md px-5 py-4 mb-2 <?=$alert?> text-white"><?=$flash?></div>
                <?php endif; ?>


                <h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">Məlumatları daxil edin</h2>

                <form action="" method="POST" autocomplete="off">
                    <div class="grid grid-cols-12 gap-12">

                        <div class="col-span-12 xl:col-span-6">
                            <div class="mt-3">
                                <label><?=$a_tr_16?> * </label>
                                <input type="text" name="first_name" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_17?>* </label>
                                <input type="text" name="last_name" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_18?> * </label>
                                <input type="text" name="father_name" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_27?> * </label>
                                <input type="text" name="phone" class="phone input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_31?> * </label>
                                <input type="email" name="email" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_60?> * </label>
                                <input type="text" name="country_live" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_61?> * </label>
                                <input type="text" name="groupNo" class="input w-full border mt-2">
                            </div>
                        </div>

                        <div class="col-span-12 xl:col-span-6">
                            <div class="mt-3">
                                <label><?=$a_tr_62?> * </label>
                                <input type="text" name="specialty" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_63?> * </label>
                                <select class="input w-full border mt-2" name="graduate_year">
                                    <option value=""><?=$a_tr_64?></option>
                                    <?php $year = date("Y"); for($i = 1994;$i <= $year;$i++){ ?>
                                        <option value="<?=$i;?>"><?=$i;?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_65?> * </label>
                                <input type="text" name="work_location" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_66?> * </label>
                                <input type="text" name="position" class="input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_67?> * </label>
                                <input type="text" name="work_phone" class="phone input w-full border mt-2">
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_68?> * </label>
                                <select class="input w-full border mt-2" name="education_degree">
                                    <option value=""><?=$a_tr_69?></option>
                                    <option value="Bakalavr"><?=$a_tr_70?></option>
                                    <option value="Magistrtura"><?=$a_tr_71?></option>
                                    <option value="Doktorantura"><?=$a_tr_72?></option>
                                </select>
                            </div>
                            <div class="mt-3">
                                <label><?=$a_tr_73?> * </label>
                                <select class="input w-full border mt-2" name="education_forma">
                                    <option value=""><?=$a_tr_74?></option>
                                    <option value="Əyani"><?=$a_tr_75?></option>
                                    <option value="Qiyabi"><?=$a_tr_76?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-span-12 xl:col-span-12">
                            <label><?=$a_tr_77?> * </label>
                            <textarea name="university_about" class="input w-full border" rows="5"></textarea>
                        </div>
                        <div class="col-span-12 xl:col-span-12">
                            <button type="submit" name="graduate_add" value="ok" class="button qeydiyyat_ol w-full xl:w-32 text-white bg-theme-1 xl:mr-3">Qeydiyyat</button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
        <!-- END: Register Form -->
    </div>
</div>
<!-- BEGIN: Dark Mode Switcher-->
<!-- END: Dark Mode Switcher-->
<!--
<script src="<?=$site_url?>dist/js/app.js"></script>
        -->
</body>
</html>




<script src="<?=$site_url?>dist/js/jquery-3.3.1.min.js"></script>
<script src="<?=$site_url?>dist/js/jquery.inputmask.bundle.js"></script>
<script type="text/javascript">
    $('.datepicker').val('');

    $(document).on('click keyup change','.phone',function(){
        $(".phone").inputmask({
            mask:[{mask:"(###) ###-##-##"}],
            greedy:!1,
            definitions:{"#":{validator:"[0-9]",cardinality:1}}
        })
    });

</script>

